/**
* \file: AlsaAudioOutImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_ALSAAUDIOOUTIMPL_H
#define CARPLAY_ALSAAUDIOOUTIMPL_H

#include <atomic>
#include <string>
#include <vector>
#include <memory>
#include <carplay_plugin.h>
#include <alsa/asoundlib.h>
#include "AlsaAudioCommon.h"

typedef unsigned long int pthread_t;

namespace adit { namespace carplay
{

class AlsaAudioIn::Impl : public IAudioInAdapter
{
public :
    Impl();
    virtual ~Impl();

    // IAudioOutAdapter implementation
    // no thread-safety required
public:
    virtual bool Initialize(const IConfiguration& inConfig, IAudioInSink& inSink);
    virtual bool Prepare(AudioFormatStruct inFormat, const std::string& inAudioType);
    virtual bool Start();
    virtual void Stop();

    // private section
private:
    const IConfiguration* config;

    IAudioInSink* sink;
    pthread_t processThreadId;

    std::string deviceName;
    uint32_t periodMilli;
    uint32_t periodSamples;
    uint32_t appendEmptyPeriods;
    AudioFormatStruct format;

    std::atomic_bool running;

    std::unique_ptr<AlsaAudioCommon> alsa;

    static void* process(void* inData);

    bool parseDeviceSettings();
    bool getDeviceName(AudioChannelType inChannel, std::string& outDeviceName);
    int getPeriodMilli(const std::string& inDeviceName, int inSampleRate);
    bool getDeviceSettings(const std::string& inAudioType);

};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_ALSAAUDIOOUTIMPL_H */
